/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.placement;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.DyeableComponent;
import com.technicalitiesmc.lib.circuit.placement.PlacementContext;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.placement.SinglePlacement;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class SimplePlacement
extends SinglePlacement<State> {
    private final RegistryObject<ComponentType> type;
    private final boolean requiresSolidSurface;

    public SimplePlacement(RegistryObject<ComponentType> type, boolean tryClickPosition, boolean requiresSolidSurface) {
        super(tryClickPosition);
        this.type = type;
        this.requiresSolidSurface = requiresSolidSurface;
    }

    @Override
    @Nullable
    protected State tryCaptureState(PlacementContext.Client context, Vec3i pos, VecDirection clickedFace) {
        if ((!this.requiresSolidSurface || context.isTopSolid(pos.m_7495_())) && context.canPlace(pos, (ComponentType)this.type.get())) {
            return new State(pos);
        }
        return null;
    }

    @Override
    protected void serializeState(FriendlyByteBuf buf, State state) {
        state.serialize(buf);
    }

    @Override
    protected State deserializeState(FriendlyByteBuf buf) {
        return State.deserialize(buf);
    }

    @Override
    protected void put(PlacementContext.Server context, State state) {
        if (context.tryPut(state.pos(), (ComponentType)this.type.get(), ctx -> {
            CircuitComponent component = ((ComponentType)this.type.get()).create(ctx);
            if (component instanceof DyeableComponent) {
                DyeColor color;
                DyeableComponent c = (DyeableComponent)component;
                ItemStack offHandItem = context.getPlayer().m_21206_();
                if (!offHandItem.m_41619_() && (color = Utils.getDyeColor((ItemStack)offHandItem)) != null) {
                    c.setColor(color);
                }
            }
            return component;
        })) {
            context.consumeItems(1);
            context.playSound();
        }
    }

    public record State(Vec3i pos) {
        public void serialize(FriendlyByteBuf buf) {
            buf.writeInt(this.pos().m_123341_()).writeInt(this.pos().m_123342_()).writeInt(this.pos().m_123343_());
        }

        public static State deserialize(FriendlyByteBuf buf) {
            Vec3i pos = new Vec3i(buf.readInt(), buf.readInt(), buf.readInt());
            return new State(pos);
        }
    }
}

